/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

float		g_currentTime;

float2		wake_maskOrigin;
float2		wake_maskMulti;
float2		wake_terrainOffsetPosition;
float		wake_noiseMulti;

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4	position	:	POSITION;
	float4	colour		:	COLOR;
	float2	uv			:	TEXCOORD0;
};

struct VS_OUTPUT
{
	float4	position	:	POSITION;
	float2	uvPlane		:	TEXCOORD0;
	float2	uvNoise		:	TEXCOORD1;
	float2	uvMask		:	TEXCOORD2;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT vs_water_3d_wake( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;

	output.position = input.position;

	output.uvPlane = input.uv;
	output.uvMask = wake_maskOrigin + input.uv * wake_maskMulti;
	output.uvNoise = (float2( output.position.x - wake_terrainOffsetPosition.x, output.position.z - wake_terrainOffsetPosition.y) / 102400.0f) * 200.0f + float2(g_currentTime * 0.000035f,0);

	output.position = mul(output.position, shader_transform_viewProj);

	return output;
}

/////////////////////////////////////////////////////////////////////////

sampler sampler_noise = sampler_state
{
	Texture = (shader_texture_0);
	AddressU=Wrap;
	AddressV=Wrap;
};

sampler sampler_water_height_map = sampler_state
{
	Texture = (shader_texture_1);
	AddressU=Clamp;
	AddressV=Clamp;
	MipFilter = NONE; 
};

sampler sampler_water_wake = sampler_state
{
	Texture = (shader_texture_2);
};

/////////////////////////////////////////////////////////////////////////

float4 ps_water_3d_wake( VS_OUTPUT input ) : COLOR
{
	// wake alpha

	float nWakeAlpha = tex2D(sampler_water_wake, input.uvPlane + (tex2D(sampler_noise,input.uvNoise).rg-0.5f) * 0.075f).a;


	// final colour

	return float4( 1,1,1, nWakeAlpha );
}

////////////////////////////////////////////////////////////

technique water_3d_wake_11_20
{
	pass P0
	{
		AlphaBlendEnable = True;
		AlphaTestEnable = False;

		VertexShader = compile vs_1_1 vs_water_3d_wake();	
		PixelShader = compile ps_2_0 ps_water_3d_wake();	
	}
}

technique water_3d_wake_11_00
{
	pass P0
	{
	}
}